/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.jatter.processors;

import de.binfalse.jatter.Config;
import de.binfalse.jatter.JatterTools;
import java.text.SimpleDateFormat;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Status;

public class TwitterStatusProcessor
implements Processor {
    private static Logger LOG = LoggerFactory.getLogger(TwitterStatusProcessor.class);
    public static final SimpleDateFormat printDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Config config;

    public TwitterStatusProcessor(Config config) {
        this.config = config;
    }

    public void process(Exchange exchange) throws Exception {
        exchange.getIn().setBody((Object)("\n" + TwitterStatusProcessor.translateTwitterStatus((Status)exchange.getIn().getBody())));
    }

    public static String translateTwitterStatus(Status status) {
        String msg = "";
        if (status.getUser() != null && status.getUser().getScreenName() != null) {
            msg = msg + "*" + status.getUser().getScreenName() + "*: ";
        }
        if (!status.isRetweet()) {
            msg = msg + JatterTools.processTwitterMessag(status.getText());
        }
        msg = msg + " [" + printDateFormat.format(status.getCreatedAt());
        if (status.getGeoLocation() != null) {
            msg = msg + " - " + status.getGeoLocation().getLatitude() + "," + status.getGeoLocation().getLongitude();
        }
        msg = msg + " - " + status.getId();
        msg = msg + "]";
        if (status.isRetweet()) {
            msg = msg + "\n *RT* > " + TwitterStatusProcessor.translateTwitterStatus(status.getRetweetedStatus());
        }
        if (status.getQuotedStatus() != null) {
            msg = msg + "\n *QT* > " + TwitterStatusProcessor.translateTwitterStatus(status.getQuotedStatus());
        }
        return msg;
    }
}

