/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.jatter;

import de.binfalse.bflog.LOGGER;
import de.binfalse.jatter.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class JatterTools {
    private static Pattern urlPattern = Pattern.compile("\\b(((ht|f)tp(s?)\\:\\/\\/|~\\/|\\/)|www.)(\\w+:\\w+@)?(([-\\w]+\\.)+(com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|[a-z]{2}))(:[\\d]{1,5})?(((\\/([-\\w~!$+|.,=]|%[a-f\\d]{2})+)+|\\/)+|\\?|#)?((\\?([-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)(&(?:[-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)*)*(#([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)?\\b");
    private static Pattern refreshUrlPatern = Pattern.compile("0;URL=([^\"]+)\"");
    private static Twitter twitter;

    public static String processTwitterMessag(String msg) {
        LOGGER.debug((Object[])new Object[]{"processing twitter message: ", msg});
        return JatterTools.expandUrls(msg);
    }

    public static String expandUrls(String msg) {
        LOGGER.debug((Object[])new Object[]{"expanding URLs in: ", msg});
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = urlPattern.matcher(msg);
        while (matcher.find()) {
            LOGGER.debug((Object[])new Object[]{"found url: ", matcher.group()});
            String res = JatterTools.expandUrl(matcher.group());
            LOGGER.debug((Object[])new Object[]{"expander expanded to: ", res});
            if (res.equals(matcher.group())) continue;
            map.put(matcher.group(), res);
        }
        for (String url : map.keySet()) {
            msg = msg.replace(url, (CharSequence)map.get(url));
        }
        return msg;
    }

    public static Twitter getTwitterInstance(Config conf) {
        if (twitter == null) {
            ConfigurationBuilder confBuilder = new ConfigurationBuilder();
            confBuilder.setOAuthConsumerKey(conf.getTwitterConsumerKey());
            confBuilder.setOAuthConsumerSecret(conf.getTwitterConsumerSecret());
            confBuilder.setOAuthAccessToken(conf.getTwitterAccesstoken());
            confBuilder.setOAuthAccessTokenSecret(conf.getTwitterAccesstokenSecret());
            twitter = new TwitterFactory(confBuilder.build()).getInstance();
        }
        return twitter;
    }

    public static String expandUrl(String u) {
        LOGGER.debug((Object[])new Object[]{"expanding URL: ", u});
        try {
            URL url = new URL(u);
            URLConnection urlCon = url.openConnection();
            urlCon.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            urlCon.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            urlCon.setRequestProperty("Connection", "keep-alive");
            urlCon.setRequestProperty("Accept-Encode", "gzip, deflate, br");
            urlCon.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:45.0) Gecko/20100101 Firefox/45.0");
            HttpURLConnection httpUrlCon = (HttpURLConnection)HttpURLConnection.class.cast(urlCon);
            httpUrlCon.setReadTimeout(10000);
            if (u.equals(httpUrlCon.getURL().toString()) && httpUrlCon.getResponseCode() < 300) {
                BufferedReader in = new BufferedReader(new InputStreamReader(httpUrlCon.getInputStream()));
                String line = null;
                String newU = null;
                while ((line = in.readLine()) != null) {
                    if (!line.contains("http-equiv=\"refresh\"")) continue;
                    LOGGER.debug((Object[])new Object[]{"found an inline http-equiv: ", line, " -- trying to follow that"});
                    Matcher matcher = refreshUrlPatern.matcher(line);
                    if (!matcher.find()) continue;
                    newU = matcher.group(1);
                    break;
                }
                in.close();
                if (newU != null) {
                    return JatterTools.expandUrl(newU);
                }
            }
            LOGGER.debug((Object[])new Object[]{"unshorting URL: ", u, " -> ", httpUrlCon.getURL()});
            return httpUrlCon.getURL().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error((Exception)e, (Object[])new Object[]{"error expanding ", u});
            return u;
        }
    }
}

