/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.sbgn.InputStreamToReader;
import org.sbgn.Language;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SbgnVersionFinder {
    private static VersionHandler parse(File file) throws FileNotFoundException, IOException, SAXException {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        VersionHandler versionHandler = new VersionHandler();
        xr.setContentHandler(versionHandler);
        xr.setErrorHandler(versionHandler);
        xr.parse(new InputSource(InputStreamToReader.inputStreamToReader(new FileInputStream(file))));
        return versionHandler;
    }

    public static int getVersion(File file) throws SAXException, FileNotFoundException, IOException {
        VersionHandler versionHandler = SbgnVersionFinder.parse(file);
        return versionHandler.getVersion();
    }

    public static Language getLanguage(File file) throws FileNotFoundException, IOException, SAXException {
        VersionHandler versionHandler = SbgnVersionFinder.parse(file);
        return versionHandler.getLanguage();
    }

    static class VersionHandler
    extends DefaultHandler {
        private int version = -1;
        private Language lang = null;

        VersionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String l;
            if ("sbgn".equals(qName)) {
                this.version = "http://sbgn.org/libsbgn/0.2".equals(uri) ? 2 : ("http://sbgn.org/libsbgn/pd/0.1".equals(uri) ? 1 : -1);
            } else if ("map".equals(qName) && (l = attributes.getValue("language")) != null) {
                this.lang = Language.fromString(l);
            }
        }

        public int getVersion() {
            return this.version;
        }

        public Language getLanguage() {
            return this.lang;
        }
    }
}

