/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.morre.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import de.unirostock.sems.morre.client.FeatureSet;
import de.unirostock.sems.morre.client.Morre;
import de.unirostock.sems.morre.client.MorreCrawlerInterface;
import de.unirostock.sems.morre.client.dataholder.AnnotationResult;
import de.unirostock.sems.morre.client.dataholder.CrawledModel;
import de.unirostock.sems.morre.client.dataholder.ModelResult;
import de.unirostock.sems.morre.client.dataholder.PersonResult;
import de.unirostock.sems.morre.client.dataholder.PublicationResult;
import de.unirostock.sems.morre.client.exception.MorreClientException;
import de.unirostock.sems.morre.client.exception.MorreCommunicationException;
import de.unirostock.sems.morre.client.exception.MorreException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpMorreClient
implements Morre,
MorreCrawlerInterface,
Serializable {
    private static final long serialVersionUID = 6215972631957486031L;
    private final Log log = LogFactory.getLog(this.getClass());
    private URL morreUrl = null;
    private URL queryUrl = null;
    private HttpClient httpClient = null;
    private Gson gson = null;
    private Type singleListType;
    private Type featureListType;
    private Type modelResultType;
    private Type personResultType;
    private Type publicationResultType;
    private Type annotationResultType;
    private Type crawledModelType;
    private Type singleMapType;
    private static final String REST_URL_QUERY = "query/";
    private static final String REST_URL_CRAWLER = "model_crawler_service/";
    private static final String REST_URL_UPDATE = "model_update_service/";
    private static final String KEY_KEYWORDS = "keywords";
    private static final String KEY_FEATURES = "features";
    private static final String KEY_SINGLE_KEYWORD = "keyword";
    private static final String AGGREGATION_TYPE = "aggregationType";
    private static final String RANKERS_WEIGHTS = "rankersWeights";
    private static final String ERROR_KEY_RESULTS = "#Results";
    private static final String ERROR_KEY_EXCEPTION = "Exception";
    private static final String SERVICE_GET_MODEL_HISTORY = "model_crawler_service/get_model_history";
    private static final String SERVICE_GET_MODEL_VERSION = "model_crawler_service/get_model_version";
    private static final String SERVICE_GET_LATEST_MODEL = "model_crawler_service/get_model";
    private static final String SERVICE_ADD_MODEL = "model_update_service/add_model";
    private static final String SERVICE_ADD_MODEL_VERSION = "model_update_service/add_model_version";
    private static final String SERVICE_DELETE_MODEL = "model_update_service/delete_model";
    private static final String SKEY_FILEID = "fileId";
    private static final String SKEY_VERSIONID = "versionId";
    private static final String SKEY_EXCEPTION = "Exception";

    public HttpMorreClient(String morreUrl) throws MalformedURLException {
        this.morreUrl = new URL(morreUrl);
        this.queryUrl = new URL(this.morreUrl, REST_URL_QUERY);
        this.httpClient = HttpClientBuilder.create().build();
        this.gson = new Gson();
        this.singleListType = new TypeToken<List<String>>(){}.getType();
        this.featureListType = new TypeToken<List<String>>(){}.getType();
        this.modelResultType = new TypeToken<List<ModelResult>>(){}.getType();
        this.personResultType = new TypeToken<List<PersonResult>>(){}.getType();
        this.publicationResultType = new TypeToken<List<PublicationResult>>(){}.getType();
        this.annotationResultType = new TypeToken<List<AnnotationResult>>(){}.getType();
        this.crawledModelType = new TypeToken<CrawledModel>(){}.getType();
        this.singleMapType = new TypeToken<Map<String, String>>(){}.getType();
    }

    @Override
    public List<ModelResult> modelQuery(String query) throws MorreClientException, MorreCommunicationException, MorreException {
        return this.doSimpleModelQuery("model_query", query);
    }

    @Override
    public List<ModelResult> aggregatedModelQuery(String query, String aggregationType, String rankersWeights) throws MorreClientException, MorreCommunicationException, MorreException {
        return this.doSimpleAggregatedModelQuery("aggregated_model_query", query, aggregationType, rankersWeights);
    }

    @Override
    public List<String> getQueryFeatures(String queryType) throws MorreException, MorreClientException, MorreCommunicationException {
        try {
            HttpGet request = new HttpGet(new URL(this.queryUrl, queryType).toString());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StringBuilder result = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                result.append(line);
            }
            List featureList = (List)this.gson.fromJson(result.toString(), this.featureListType);
            return featureList;
        }
        catch (JsonSyntaxException e) {
            throw new MorreException("Can not parse the FeatureSet List!", e);
        }
        catch (MalformedURLException e) {
            throw new MorreClientException("Exception while building the request url", e);
        }
        catch (IOException e) {
            throw new MorreCommunicationException("Error while HTTP Request.", e);
        }
    }

    @Override
    public List<ModelResult> doModelQuery(String queryType, FeatureSet features) throws MorreClientException, MorreCommunicationException, MorreException {
        String resultString = this.performQuery(queryType, features);
        return this.parseQueryResult(resultString, this.modelResultType);
    }

    @Override
    public List<ModelResult> doSimpleModelQuery(String queryType, String keyword) throws MorreException, MorreClientException, MorreCommunicationException {
        String resultString = this.performSimpleQuery(queryType, keyword);
        return this.parseQueryResult(resultString, this.modelResultType);
    }

    @Override
    public List<ModelResult> doSimpleAggregatedModelQuery(String queryType, String keyword, String aggregationType, String rankersWeights) throws MorreException, MorreClientException, MorreCommunicationException {
        String resultString = this.performSimpleAggregatedQuery(queryType, keyword, aggregationType, rankersWeights);
        return this.parseQueryResult(resultString, this.modelResultType);
    }

    @Override
    public List<PersonResult> doPersonQuery(FeatureSet features) throws MorreClientException, MorreCommunicationException, MorreException {
        String resultString = this.performQuery("person_query", features);
        return this.parseQueryResult(resultString, this.personResultType);
    }

    @Override
    public List<AnnotationResult> doAnnotationQuery(String query) throws MorreClientException, MorreCommunicationException, MorreException {
        String resultString = this.performSimpleQuery("annotation_query", query);
        return this.parseQueryResult(resultString, this.annotationResultType);
    }

    @Override
    public List<PublicationResult> doPublicationQuery(FeatureSet features) throws MorreException, MorreClientException, MorreCommunicationException {
        String resultString = this.performQuery("publication_query", features);
        return this.parseQueryResult(resultString, this.publicationResultType);
    }

    private <R> List<R> parseQueryResult(String resultString, Type parseType) throws MorreClientException, MorreCommunicationException, MorreException {
        List result = null;
        try {
            result = (List)this.gson.fromJson(resultString, parseType);
        }
        catch (JsonSyntaxException e) {
            try {
                List errorResult = (List)this.gson.fromJson(resultString, this.featureListType);
                if (errorResult == null || errorResult.isEmpty()) {
                    throw new MorreException("Empty result, no error description.");
                }
                if (((String)errorResult.get(0)).equals(ERROR_KEY_RESULTS)) {
                    if (((String)errorResult.get(1)).equals("0")) {
                        return null;
                    }
                }
                if (((String)errorResult.get(0)).equals("Exception")) {
                    if (errorResult.size() >= 2) {
                        throw new MorreException((String)errorResult.get(1));
                    }
                    throw new MorreException();
                }
                throw new MorreException(MessageFormat.format("Unknown Result was returned by MORRE: {0}", errorResult));
            }
            catch (JsonSyntaxException e2) {
                System.out.println(resultString);
                throw new MorreCommunicationException("Can not even parse the error message. Check for corrupt JSON!", e);
            }
        }
        return result;
    }

    private String performQuery(String queryType, FeatureSet features) throws MorreClientException, MorreCommunicationException {
        try {
            Map.Entry<List<String>, List<String>> separateLists = features.getFeatures();
            HashMap<String, JsonElement> complete = new HashMap<String, JsonElement>();
            complete.put(KEY_FEATURES, this.gson.toJsonTree(separateLists.getKey(), this.singleListType));
            complete.put(KEY_KEYWORDS, this.gson.toJsonTree(separateLists.getValue(), this.singleListType));
            String jsonFeatures = this.gson.toJson(complete);
            HttpPost request = new HttpPost(new URL(this.queryUrl, queryType).toString());
            request.setEntity((HttpEntity)new StringEntity(jsonFeatures, ContentType.APPLICATION_JSON));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StringBuilder result = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            throw new MorreClientException("Exception while building the request url", e);
        }
        catch (IOException e) {
            throw new MorreCommunicationException("Error while HTTP Request.", e);
        }
    }

    private String performSimpleQuery(String queryType, String keyword) throws MorreClientException, MorreCommunicationException {
        try {
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put(KEY_SINGLE_KEYWORD, keyword);
            String jsonFeatures = this.gson.toJson(parameter);
            String requestUrl = new URL(this.queryUrl, queryType).toString();
            HttpPost request = new HttpPost(requestUrl);
            request.setEntity((HttpEntity)new StringEntity(jsonFeatures, ContentType.APPLICATION_JSON));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StringBuilder result = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            throw new MorreClientException("Exception while building the request url", e);
        }
        catch (IOException e) {
            throw new MorreCommunicationException("Error while HTTP Request.", e);
        }
    }

    private String performSimpleAggregatedQuery(String queryType, String keyword, String aggregationType, String rankersWeights) throws MorreClientException, MorreCommunicationException {
        try {
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put(KEY_SINGLE_KEYWORD, keyword);
            parameter.put(AGGREGATION_TYPE, aggregationType);
            parameter.put(RANKERS_WEIGHTS, rankersWeights);
            String jsonFeatures = this.gson.toJson(parameter);
            String requestUrl = new URL(this.queryUrl, queryType).toString();
            HttpPost request = new HttpPost(requestUrl);
            request.setEntity((HttpEntity)new StringEntity(jsonFeatures, ContentType.APPLICATION_JSON));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StringBuilder result = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            throw new MorreClientException("Exception while building the request url", e);
        }
        catch (IOException e) {
            throw new MorreCommunicationException("Error while HTTP Request.", e);
        }
    }

    @Override
    public List<String> getModelHistory(String fileId) throws MorreClientException, MorreCommunicationException, MorreException {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put(SKEY_FILEID, fileId);
        String result = this.performServiceQuery(SERVICE_GET_MODEL_HISTORY, parameter);
        return (List)this.parseServiceResult(result, this.singleListType);
    }

    @Override
    public CrawledModel getModelVersion(String fileId, String versionId) throws MorreClientException, MorreCommunicationException, MorreException {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put(SKEY_FILEID, fileId);
        parameter.put(SKEY_VERSIONID, versionId);
        String result = this.performServiceQuery(SERVICE_GET_MODEL_VERSION, parameter);
        return (CrawledModel)this.parseServiceResult(result, this.crawledModelType);
    }

    @Override
    public CrawledModel getLatestModelVersion(String fileId) throws MorreClientException, MorreCommunicationException, MorreException {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put(SKEY_FILEID, fileId);
        String result = this.performServiceQuery(SERVICE_GET_LATEST_MODEL, parameter);
        System.out.println(result);
        return (CrawledModel)this.parseServiceResult(result, this.crawledModelType);
    }

    @Override
    public boolean addModel(CrawledModel model) throws MorreClientException, MorreCommunicationException, MorreException {
        String result = this.performServiceQuery(SERVICE_ADD_MODEL_VERSION, model, this.crawledModelType);
        this.log.trace((Object)result);
        System.out.println("----");
        System.out.println(result);
        System.out.println("----");
        this.log.debug((Object)result);
        Map parsedResult = (Map)this.parseServiceResult(result, this.singleMapType);
        return parsedResult != null && ((String)parsedResult.get("ok")).toLowerCase().equals("true");
    }

    private <R> String performServiceQuery(String queryType, R parameter) throws MorreClientException, MorreCommunicationException {
        return this.performServiceQuery(queryType, parameter, null);
    }

    private <R> String performServiceQuery(String queryType, R parameter, Type parameterType) throws MorreClientException, MorreCommunicationException {
        try {
            String jsonFeatures = null;
            jsonFeatures = parameterType != null ? this.gson.toJson(parameter, parameterType) : this.gson.toJson(parameter);
            String requestUrl = new URL(this.morreUrl, queryType).toString();
            HttpPost request = new HttpPost(requestUrl);
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            System.out.println(jsonFeatures);
            this.log.trace((Object)jsonFeatures);
            request.setEntity((HttpEntity)new StringEntity(jsonFeatures, ContentType.APPLICATION_JSON));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StringBuilder result = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            throw new MorreClientException("Exception while building the request url", e);
        }
        catch (IOException e) {
            throw new MorreCommunicationException("Error while HTTP Request.", e);
        }
    }

    private <R> R parseServiceResult(String result, Type resultType) throws MorreCommunicationException, MorreException {
        Object resultObj = null;
        try {
            resultObj = this.gson.fromJson(result, resultType);
            if (resultObj instanceof Map && ((Map)resultObj).containsKey("Exception")) {
                this.analyseServiceException((Map)resultObj);
            }
        }
        catch (JsonSyntaxException e) {
            try {
                Map resultMap = (Map)this.gson.fromJson(result, this.singleMapType);
                this.analyseServiceException(resultMap, e);
            }
            catch (JsonSyntaxException e2) {
                throw new MorreCommunicationException("Can not even parse the error message. Check for corrupt JSON! " + result, e);
            }
        }
        return (R)resultObj;
    }

    private void analyseServiceException(Map<?, ?> resultMap) throws MorreException {
        this.analyseServiceException(resultMap, null);
    }

    private void analyseServiceException(Map<?, ?> resultMap, Throwable e) throws MorreException {
        if (resultMap.get("Exception") != null && resultMap.get("Exception") instanceof String) {
            String error = "Server-Side exception while request: " + (String)resultMap.get("Exception");
            if (e != null) {
                throw new MorreException(error, e);
            }
            throw new MorreException(error);
        }
    }
}

