/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.morre.client.dataholder;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrawledModel
implements Serializable {
    private static final long serialVersionUID = 2002369276523885214L;
    private static transient Gson gson = null;
    private static transient Type metaType = new TypeToken<Map<String, String>>(){}.getType();
    public static final String TYPE_CELLML = "CELLML";
    public static final String TYPE_SBML = "SBML";
    public static final String TYPE_SEDML = "SEDML";
    public static final String META_CRAWLED_DATE = "crawledDate";
    public static final String META_VERSION_DATE = "versionDate";
    public static final String META_SOURCE = "source";
    public static final String SOURCE_PMR2 = "PMR2";
    public static final String SOURCE_BIOMODELS_DB = "BMDB";
    private String fileId;
    private String versionId;
    private String xmldoc;
    private String modelType;
    private String meta;
    private Map<String, List<String>> parentMap = new HashMap<String, List<String>>();
    private Map<String, String> metaMap = new HashMap<String, String>(5);

    public CrawledModel(String fileId, String versionId, String xmldoc, Map<String, List<String>> parentMap, Map<String, String> metaMap, String modelType) {
        this.fileId = fileId;
        this.versionId = versionId;
        this.xmldoc = xmldoc;
        this.parentMap = parentMap;
        this.metaMap = metaMap;
        this.modelType = modelType;
    }

    public Map<String, String> getMetaMap() {
        if (this.meta != null && !this.meta.isEmpty() && this.metaMap == null) {
            this.processMeta();
        }
        return this.metaMap;
    }

    public void setMetaMap(Map<String, String> metaMap) {
        this.metaMap = metaMap;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getXmldoc() {
        return this.xmldoc;
    }

    public void setXmldoc(String xmldoc) {
        this.xmldoc = xmldoc;
    }

    public Map<String, List<String>> getParentMap() {
        return this.parentMap;
    }

    public void setParentMap(Map<String, List<String>> parentMap) {
        this.parentMap = parentMap;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMeta() {
        return this.meta;
    }

    protected void processMeta() {
        if (gson == null) {
            gson = new Gson();
        }
        this.metaMap = (Map)gson.fromJson(this.meta, metaType);
    }

    public String toString() {
        return "CrawledModel [fileId=" + this.fileId + ", versionId=" + this.versionId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + (this.metaMap == null ? 0 : this.metaMap.hashCode());
        result = 31 * result + (this.modelType == null ? 0 : this.modelType.hashCode());
        result = 31 * result + (this.parentMap == null ? 0 : this.parentMap.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        result = 31 * result + (this.xmldoc == null ? 0 : this.xmldoc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrawledModel other = (CrawledModel)obj;
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        if (this.metaMap == null ? other.metaMap != null : !this.metaMap.equals(other.metaMap)) {
            return false;
        }
        if (this.modelType == null ? other.modelType != null : !this.modelType.equals(other.modelType)) {
            return false;
        }
        if (this.parentMap == null ? other.parentMap != null : !this.parentMap.equals(other.parentMap)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return !(this.xmldoc == null ? other.xmldoc != null : !this.xmldoc.equals(other.xmldoc));
    }
}

