/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.ds;

import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;

public abstract class TreeNode {
    public static final String TEXT_TAG = "text()";
    public static final int UNCHANGED = 0;
    public static final int UNMAPPED = 1;
    public static final int MOVED = 2;
    public static final int MODIFIED = 4;
    public static final int SUB_MODIFIED = 8;
    public static final int COPIED = 16;
    public static final int GLUED = 32;
    public static final int KIDSSWAPPED = 64;
    public static final int SWAPPEDKID = 128;
    public static final int SUBTREEUNMAPPED = 256;
    public static final int DOC_NODE = 1;
    public static final int TEXT_NODE = 2;
    protected int modified;
    protected int type;
    protected String xPath;
    protected DocumentNode parent;
    protected TreeDocument doc;
    protected int level;
    protected String ownHash;

    public TreeNode(int type, DocumentNode parent, TreeDocument doc, int level) {
        this.doc = doc;
        this.type = type;
        this.parent = parent;
        this.modified = 0;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public int getModification() {
        return this.modified;
    }

    public void rmModification(int mod) {
        this.modified &= ~mod;
    }

    public void addModification(int mod) {
        this.modified |= mod;
    }

    public void setModification(int mod) {
        this.modified = mod;
    }

    public boolean hasModification(int mod) {
        return (this.modified & mod) > 0;
    }

    public int getType() {
        return this.type;
    }

    public DocumentNode getParent() {
        return this.parent;
    }

    public String getXPath() {
        return this.xPath;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void resetModifications() {
        this.modified = 0;
        if (this.type == 1) {
            List<TreeNode> kids = ((DocumentNode)this).getChildren();
            for (TreeNode kid : kids) {
                kid.resetModifications();
            }
        }
    }

    public TreeDocument getDocument() {
        return this.doc;
    }

    public boolean networkDiffers(TreeNode tn, ConnectionManager conMgmr, Connection c) {
        DocumentNode p = this.getParent();
        DocumentNode tnp = tn.getParent();
        if (p == null && tnp == null) {
            return false;
        }
        if (p == null || tnp == null) {
            return true;
        }
        if (!conMgmr.parentsConnected(c)) {
            if (p != null) {
                p.addModification(8);
            }
            if (tnp != null) {
                tnp.addModification(8);
            }
            return true;
        }
        if (p.getNoOfChild(this) != tnp.getNoOfChild(tn)) {
            p.addModification(64);
            tnp.addModification(64);
            this.addModification(128);
            tn.addModification(128);
        }
        return false;
    }

    public boolean contentDiffers(TreeNode tn) {
        if (this.type != tn.type) {
            return true;
        }
        return !this.ownHash.equals(tn.ownHash);
    }

    public abstract String getTagName();

    public abstract double getWeight();

    public abstract String getOwnHash();

    public abstract String getSubTreeHash();

    public abstract boolean evaluate(ConnectionManager var1);

    public abstract String dump(String var1);

    public abstract Element getSubDoc(Element var1);

    protected abstract void reSetupStructureDown(TreeDocument var1, int var2);

    protected abstract void reSetupStructureUp();

    public abstract void getNodeStats(HashMap<String, Integer> var1);
}

