/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.tools;

import de.binfalse.bfutils.FileRetriever;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlTools {
    private static SAXBuilder builder;

    public static SAXBuilder getBuilder() {
        return new SAXBuilder();
    }

    public static Document readDocument(File file) throws IOException, JDOMException {
        if (builder == null) {
            builder = XmlTools.getBuilder();
        }
        return builder.build((InputStream)new FileInputStream(file));
    }

    public static Document readDocument(URL url) throws IOException, URISyntaxException, JDOMException {
        if (builder == null) {
            builder = XmlTools.getBuilder();
        }
        File tmp = File.createTempFile("Bives", "download");
        tmp.deleteOnExit();
        HashMap<String, String> addHeaders = new HashMap<String, String>();
        addHeaders.put("Accept", "application/xml");
        FileRetriever.getFile((URI)url.toURI(), (File)tmp, addHeaders);
        return builder.build((InputStream)new FileInputStream(tmp));
    }

    public static Document readDocument(InputStream is) throws IOException, JDOMException {
        if (builder == null) {
            builder = XmlTools.getBuilder();
        }
        return builder.build(is);
    }

    public static Document readDocument(String doc) throws IOException, JDOMException {
        if (builder == null) {
            builder = XmlTools.getBuilder();
        }
        return builder.build((InputStream)new ByteArrayInputStream(doc.getBytes()));
    }

    public static String printDocument(Document doc) {
        return new XMLOutputter(Format.getCompactFormat()).outputString(doc);
    }

    public static String prettyPrintDocument(Document doc) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(doc);
    }
}

