/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.tools;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.SimpleOutputStream;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;

public class DocumentTools {
    private static SAXBuilder builder;
    private static Transformer mathTransformer;

    public static Document getDoc(TreeDocument treeDoc) {
        return DocumentTools.getSubDoc(treeDoc.getRoot());
    }

    public static Document getSubDoc(DocumentNode node) {
        try {
            if (builder == null) {
                builder = XmlTools.getBuilder();
            }
            Document d = new Document(node.getSubDoc(null));
            return d;
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error creating subdoc"});
            return null;
        }
    }

    public static String printSubDoc(DocumentNode node) {
        try {
            if (builder == null) {
                builder = XmlTools.getBuilder();
            }
            return XmlTools.printDocument(new Document(node.getSubDoc(null)));
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error creating subdoc"});
            return "error creating doc: " + e.getMessage();
        }
    }

    public static String printPrettySubDoc(DocumentNode node) {
        try {
            if (builder == null) {
                builder = XmlTools.getBuilder();
            }
            return XmlTools.prettyPrintDocument(new Document(node.getSubDoc(null))).toString();
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error creating subdoc"});
            return "error creating doc: " + e.getMessage();
        }
    }

    public static String transformMathML(DocumentNode doc) throws TransformerException {
        PrintStream err = System.err;
        System.setErr(new DummyPrintStream());
        if (mathTransformer == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            InputStream input = DocumentTools.class.getResourceAsStream("/res/mmlctop2_0.xsl");
            mathTransformer = tFactory.newTransformer(new StreamSource(input));
        }
        SimpleOutputStream out = new SimpleOutputStream();
        String math = DocumentTools.printSubDoc(doc);
        math = math.replaceAll("\\S+:\\S+\\s*=\\s*\"[^\"]*\"", "").replaceAll(" /", "/");
        mathTransformer.transform(new StreamSource(new ByteArrayInputStream(math.getBytes())), new StreamResult((OutputStream)out));
        System.setErr(err);
        return out.toString();
    }

    private static class DummyPrintStream
    extends PrintStream {
        public DummyPrintStream() {
            super(new ByteArrayOutputStream());
        }

        @Override
        public PrintStream append(char c) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence c) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence c, int i, int j) {
            return this;
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void print(long l) {
        }

        @Override
        public void print(float f) {
        }

        @Override
        public void print(char[] s) {
        }

        @Override
        public void println() {
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void print(Object obj) {
        }

        @Override
        public void print(double d) {
        }

        @Override
        public void print(int i) {
        }

        @Override
        public void print(char c) {
        }

        @Override
        public void print(boolean b) {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }

        @Override
        public void println(boolean x) {
        }

        @Override
        public void println(char x) {
        }

        @Override
        public void println(int x) {
        }

        @Override
        public void println(long x) {
        }

        @Override
        public void println(float x) {
        }

        @Override
        public void println(double x) {
        }

        @Override
        public void println(char[] x) {
        }

        @Override
        public void println(String x) {
        }

        @Override
        public void println(Object x) {
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return this;
        }
    }
}

